const { sequelize } = require('../config/database');
const { createAssociations } = require('../models/associations');

// Global test setup
beforeAll(async () => {
  // Create test database connection
  await sequelize.authenticate();
  
  // Create model associations
  createAssociations();
  
  // Sync database (force: true for tests)
  await sequelize.sync({ force: true });
});

// Global test teardown
afterAll(async () => {
  // Close database connection
  await sequelize.close();
});

// Global test utilities
global.testUtils = {
  createTestUser: async (userData = {}) => {
    const { User } = require('../models');
    return await User.create({
      email: 'test@example.com',
      password: 'password123',
      firstName: 'Test',
      lastName: 'User',
      role: 'tenant',
      ...userData
    });
  },
  
  createTestProperty: async (propertyData = {}) => {
    const { Property, User } = require('../models');
    const landlord = await User.findOne({ where: { role: 'landlord' } }) || 
                    await global.testUtils.createTestUser({ role: 'landlord' });
    
    return await Property.create({
      title: 'Test Property',
      type: 'apartment',
      price: 1000,
      bedrooms: 2,
      bathrooms: 1,
      address: '123 Test St',
      city: 'Test City',
      state: 'TS',
      zipCode: '12345',
      landlordId: landlord.id,
      ...propertyData
    });
  },
  
  cleanupTestData: async () => {
    const models = require('../models');
    await Promise.all(
      Object.values(models).map(model => {
        if (model.destroy) {
          return model.destroy({ where: {}, force: true });
        }
      })
    );
  }
};