const { Sequelize } = require('sequelize');

async function testConnection() {
  try {
    const sequelize = new Sequelize('stayspot', 'names', '@#Mukabwa45', {
      host: 'localhost',
      dialect: 'mysql',
      port: 3306,
      logging: console.log
    });

    await sequelize.authenticate();
    console.log('✅ Connection successful with user "names"');
    
    // Test if database exists and has tables
    const [results] = await sequelize.query('SHOW TABLES');
    console.log('📋 Tables in database:', results.map(r => Object.values(r)[0]));
    
    await sequelize.close();
  } catch (error) {
    console.error('❌ Connection failed:', error.message);
    
    // Try with root user (XAMPP default)
    try {
      const sequelizeRoot = new Sequelize('stayspot', 'root', '', {
        host: 'localhost',
        dialect: 'mysql',
        port: 3306,
        logging: console.log
      });

      await sequelizeRoot.authenticate();
      console.log('✅ Connection successful with user "root" (XAMPP default)');
      
      const [results] = await sequelizeRoot.query('SHOW TABLES');
      console.log('📋 Tables in database:', results.map(r => Object.values(r)[0]));
      
      await sequelizeRoot.close();
    } catch (rootError) {
      console.error('❌ Root connection also failed:', rootError.message);
    }
  }
}

testConnection();