require('dotenv').config();
const app = require('./app');

const PORT = process.env.PORT || 5002;

// Start server
app.listen(PORT, () => {
  console.log(`🚀 StaySpot backend server running on port ${PORT}`);
  console.log(`📊 Environment: ${process.env.NODE_ENV}`);
  console.log(`🔗 API URL: http://localhost:${PORT}/api`);
  console.log(`🗄️  Database: ${process.env.DB_NAME || 'stayspot'} on ${process.env.DB_HOST || 'localhost'}`);
});

// Handle unhandled promise rejections
process.on('unhandledRejection', (err) => {
  console.log('UNHANDLED REJECTION! 💥 Shutting down...');
  console.log(err.name, err.message);
  process.exit(1);
});

// Handle uncaught exceptions
process.on('uncaughtException', (err) => {
  console.log('UNCAUGHT EXCEPTION! 💥 Shutting down...');
  console.log(err.name, err.message);
  process.exit(1);
});