const express = require('express');
const router = express.Router();

// In-memory storage for notifications
let notifications = [];

// GET /api/notifications - Get user notifications
router.get('/', async (req, res) => {
  try {
    const userId = req.user?.id || req.query.userId;
    const userNotifications = notifications.filter(n => n.userId === userId);
    
    res.json({
      success: true,
      data: userNotifications
    });
  } catch (error) {
    res.status(500).json({
      success: false,
      message: 'Internal server error'
    });
  }
});

// POST /api/notifications - Create notification
router.post('/', async (req, res) => {
  try {
    const { userId, title, message, type = 'info' } = req.body;

    const notification = {
      id: Date.now().toString(),
      userId,
      title,
      message,
      type,
      read: false,
      createdAt: new Date().toISOString()
    };

    notifications.push(notification);

    res.status(201).json({
      success: true,
      data: notification
    });
  } catch (error) {
    res.status(500).json({
      success: false,
      message: 'Internal server error'
    });
  }
});

// PUT /api/notifications/:id/read - Mark as read
router.put('/:id/read', async (req, res) => {
  try {
    const { id } = req.params;
    const notification = notifications.find(n => n.id === id);
    
    if (notification) {
      notification.read = true;
    }

    res.json({
      success: true,
      data: notification
    });
  } catch (error) {
    res.status(500).json({
      success: false,
      message: 'Internal server error'
    });
  }
});

module.exports = router;