var ical = require('./ical')
  , fs = require('fs')

exports.parseFile = function(filename){
  return ical.parseICS(fs.readFileSync(filename, 'utf8'))
}

var rrule = require('rrule').RRule

ical.objectHandlers['RRULE'] = function(val, params, curr, stack, line){
  curr.rrule = line;
  return curr
}
var originalEnd = ical.objectHandlers['END'];
ical.objectHandlers['END'] = function (val, params, curr, stack) {
	// Recurrence rules are only valid for VEVENT, VTODO, and VJOURNAL.
	// More specifically, we need to filter the VCALENDAR type because we might end up with a defined rrule
	// due to the subtypes.
	if ((val === "VEVENT") || (val === "VTODO") || (val === "VJOURNAL")) {
		if (curr.rrule) {
			var rule = curr.rrule.replace('RRULE:', '');
			if (rule.indexOf('DTSTART') === -1) {

				if (curr.start.length === 8) {
					var comps = /^(\d{4})(\d{2})(\d{2})$/.exec(curr.start);
					if (comps) {
						curr.start = new Date(comps[1], comps[2] - 1, comps[3]);
					}
				}


				if (typeof curr.start.toISOString === 'function') {
					try {
						rule += ';DTSTART=' + curr.start.toISOString().replace(/[-:]/g, '');
						rule = rule.replace(/\.[0-9]{3}/, '');
					} catch (error) {
						console.error("ERROR when trying to convert to ISOString", error);
					}
                } else {
                    console.error("No toISOString function in curr.start", curr.start);
				}
			}
			curr.rrule = rrule.fromString(rule);
		}
	}
  return originalEnd.call(this, val, params, curr, stack);
}
