import { Tokenizer } from '@streamparser/json';
import JSON2CSVBase, { type Json2CSVBaseOptions, type NormalizedJson2CSVBaseOptions } from './BaseParser.js';
export interface StreamParserOptions {
    objectMode?: boolean;
    stringBufferSize?: number;
    numberBufferSize?: number;
}
interface ObjectModeTokenizer<TRaw> {
    isEnded?: boolean;
    write: (data: TRaw) => void;
    end: () => void;
}
export default class JSON2CSVStreamParser<TRaw extends object, T extends object> extends JSON2CSVBase<TRaw, T> {
    protected tokenizer: Tokenizer | ObjectModeTokenizer<TRaw>;
    private tokenParser;
    private _hasWritten;
    constructor(opts?: Readonly<Json2CSVBaseOptions<TRaw, T>>, asyncOpts?: Readonly<StreamParserOptions>);
    protected initTokenizer(opts: NormalizedJson2CSVBaseOptions<TRaw, T>, asyncOpts?: StreamParserOptions): void;
    protected getObjectModeTokenizer(): ObjectModeTokenizer<TRaw>;
    private configureCallbacks;
    protected getNdJsonTokenizer(asyncOpts: StreamParserOptions): Tokenizer;
    protected getBinaryModeTokenizer(asyncOpts: StreamParserOptions): Tokenizer;
    write(data: Iterable<number> | string | TRaw): void;
    end(): void;
    pushHeaderIfNotWritten(): void;
    /**
     * Generate the csv header and pushes it downstream.
     */
    pushHeader(): void;
    /**
     * Transforms an incoming json data to csv and pushes it downstream.
     *
     * @param {Object} data JSON object to be converted in a CSV row
     */
    pushLine(data: TRaw): void;
    onHeader(header: string): void;
    onLine(line: string): void;
    onData(data: string): void;
    onError(err: Error): void;
    onEnd(): void;
}
export {};
//# sourceMappingURL=StreamParser.d.ts.map