import JSON2CSVBase, { type Json2CSVBaseOptions } from './BaseParser.js';
export type ParserOptions<TRaw = object, T = TRaw> = Json2CSVBaseOptions<TRaw, T>;
export default class JSON2CSVParser<TRaw extends object, T extends object> extends JSON2CSVBase<TRaw, T> {
    constructor(opts?: Readonly<Omit<Json2CSVBaseOptions<TRaw, T>, 'ndjson'>>);
    /**
     * Main function that converts json to csv.
     *
     * @param {Array|Object} data Array of JSON objects to be converted to CSV
     * @returns {String} The CSV formated data as a string
     */
    parse(data: Array<TRaw> | TRaw): string;
    /**
     * Preprocess the data according to the give opts (unwind, flatten, etc.)
      and calculate the fields and field names if they are not provided.
     *
     * @param {Array|Object} data Array or object to be converted to CSV
     */
    preprocessData(data: Array<TRaw> | TRaw): Array<T>;
    /**
     * Create the content row by row below the header
     *
     * @param {Array} data Array of JSON objects to be converted to CSV
     * @returns {String} CSV string (body)
     */
    processData(data: Array<T>): string;
}
//# sourceMappingURL=Parser.d.ts.map