"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const string_js_1 = __importDefault(require("./string.js"));
function objectFormatter(opts = { stringFormatter: (0, string_js_1.default)() }) {
    return (value) => {
        if (value === null)
            return '';
        let stringifiedValue = JSON.stringify(value);
        if (stringifiedValue === undefined)
            return '';
        if (stringifiedValue[0] === '"')
            stringifiedValue = stringifiedValue.replace(/^"(.+)"$/, '$1');
        return opts.stringFormatter(stringifiedValue);
    };
}
exports.default = objectFormatter;
//# sourceMappingURL=object.js.map