const { USER_ROLES } = require('./validation');

const authorize = (...allowedRoles) => {
  return (req, res, next) => {
    if (!req.user) {
      return res.status(401).json({
        success: false,
        message: 'Authentication required'
      });
    }

    if (!allowedRoles.includes(req.user.role)) {
      return res.status(403).json({
        success: false,
        message: 'Insufficient permissions to access this resource'
      });
    }

    next();
  };
};

const authorizeSuperAdmin = (req, res, next) => {
  if (!req.user) {
    return res.status(401).json({
      success: false,
      message: 'Authentication required'
    });
  }

  if (req.user.role !== USER_ROLES.SUPER_ADMIN) {
    return res.status(403).json({
      success: false,
      message: 'Super admin access required'
    });
  }

  next();
};

const authorizeLandlord = (req, res, next) => {
  if (!req.user) {
    return res.status(401).json({
      success: false,
      message: 'Authentication required'
    });
  }

  const landlordRoles = [
    USER_ROLES.LANDLORD,
    USER_ROLES.SUPER_ADMIN,
    USER_ROLES.SYSTEM_ADMIN
  ];

  if (!landlordRoles.includes(req.user.role)) {
    return res.status(403).json({
      success: false,
      message: 'Landlord access required'
    });
  }

  next();
};

module.exports = { authorize, authorizeSuperAdmin, authorizeLandlord, USER_ROLES };