import jwt from 'jsonwebtoken';
import { config } from '../config/database.js';

export class JWT {
  static generateToken(payload, expiresIn = config.jwt.expire) {
    return jwt.sign(payload, config.jwt.secret, { expiresIn });
  }

  static verifyToken(token) {
    try {
      return jwt.verify(token, config.jwt.secret);
    } catch (error) {
      throw new Error('Invalid token');
    }
  }

  static decodeToken(token) {
    return jwt.decode(token);
  }

  static generateAuthTokens(user) {
    const payload = {
      id: user._id,
      email: user.email,
      role: user.role
    };

    const accessToken = this.generateToken(payload);
    const refreshToken = this.generateToken(payload, '7d');

    return {
      accessToken,
      refreshToken,
      expiresIn: config.jwt.expire
    };
  }
}

export default JWT;