const rateLimit = require('express-rate-limit');

const createRateLimiter = (windowMs, max, message) => {
  return rateLimit({
    windowMs,
    max,
    message: {
      error: 'Too many requests',
      message,
      retryAfter: `${Math.ceil(windowMs / 1000)} seconds`
    },
    standardHeaders: true,
    legacyHeaders: false
  });
};

const rateLimitConfig = {
  general: createRateLimiter(15 * 60 * 1000, 100, 'Too many requests from this IP, please try again later.'),
  auth: createRateLimiter(15 * 60 * 1000, 5, 'Too many authentication attempts, please try again later.'),
  payments: createRateLimiter(60 * 1000, 10, 'Too many payment requests, please try again later.'),
  uploads: createRateLimiter(60 * 1000, 20, 'Too many file uploads, please try again later.'),
  api: createRateLimiter(60 * 1000, 60, 'Too many API requests, please try again later.')
};

module.exports = rateLimitConfig;