const nodemailer = require('nodemailer');

// Create transporter - FIXED: createTransport not createTransporter
const transporter = nodemailer.createTransport({
  host: process.env.SMTP_HOST || 'smtp.gmail.com',
  port: process.env.SMTP_PORT || 587,
  secure: false,
  auth: {
    user: process.env.SMTP_USER,
    pass: process.env.SMTP_PASS
  }
});

// Email templates
const emailTemplates = {
  WELCOME: {
    subject: 'Welcome to StaySpot!',
    template: (name) => `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h1 style="color: #333; text-align: center;">Welcome to StaySpot, ${name}!</h1>
        <p style="color: #666; line-height: 1.6;">
          Your account has been successfully created. We're excited to have you on board!
        </p>
        <p style="color: #666; line-height: 1.6;">
          Start managing your properties efficiently with our comprehensive platform.
        </p>
        <div style="text-align: center; margin: 30px 0;">
          <a href="${process.env.FRONTEND_URL}" 
             style="background-color: #007bff; color: white; padding: 12px 24px; 
                    text-decoration: none; border-radius: 5px; display: inline-block;">
            Get Started
          </a>
        </div>
      </div>
    `
  },
  PASSWORD_RESET: {
    subject: 'Password Reset Request - StaySpot',
    template: (name, resetLink) => `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h1 style="color: #333; text-align: center;">Password Reset</h1>
        <p style="color: #666; line-height: 1.6;">Hello ${name},</p>
        <p style="color: #666; line-height: 1.6;">
          We received a request to reset your password. Click the button below to create a new password:
        </p>
        <div style="text-align: center; margin: 30px 0;">
          <a href="${resetLink}" 
             style="background-color: #dc3545; color: white; padding: 12px 24px; 
                    text-decoration: none; border-radius: 5px; display: inline-block;">
            Reset Password
          </a>
        </div>
        <p style="color: #999; font-size: 12px;">
          This link will expire in 1 hour. If you didn't request a password reset, please ignore this email.
        </p>
      </div>
    `
  },
  LEASE_CREATED: {
    subject: 'New Lease Agreement Created - StaySpot',
    template: (name, propertyAddress) => `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h1 style="color: #333; text-align: center;">New Lease Agreement</h1>
        <p style="color: #666; line-height: 1.6;">Hello ${name},</p>
        <p style="color: #666; line-height: 1.6;">
          A new lease agreement has been created for <strong>${propertyAddress}</strong>.
        </p>
        <p style="color: #666; line-height: 1.6;">
          Please review the terms and conditions in your StaySpot dashboard.
        </p>
        <div style="text-align: center; margin: 30px 0;">
          <a href="${process.env.FRONTEND_URL}/leases" 
             style="background-color: #28a745; color: white; padding: 12px 24px; 
                    text-decoration: none; border-radius: 5px; display: inline-block;">
            View Lease
          </a>
        </div>
      </div>
    `
  }
};

module.exports = { transporter, emailTemplates };