module.exports = {
  jwt: {
    secret: process.env.JWT_SECRET || 'stayspot_jwt_secret_key_2024',
    expiresIn: process.env.JWT_EXPIRES_IN || '7d',
    refreshSecret: process.env.JWT_REFRESH_SECRET || 'stayspot_refresh_secret_2024',
    refreshExpiresIn: process.env.JWT_REFRESH_EXPIRES_IN || '30d'
  },
  bcrypt: {
    saltRounds: 12
  },
  roles: {
    SUPER_ADMIN: 'super_admin',
    SYSTEM_ADMIN: 'system_admin',
    LANDLORD: 'landlord',
    TENANT: 'tenant',
    AGENT: 'agent',
    PROPERTY_MANAGER: 'property_manager',
    REGIONAL_MANAGER: 'regional_manager',
    CORPORATE_HOUSING_MANAGER: 'corporate_housing_manager',
    STUDENT_HOUSING_COORDINATOR: 'student_housing_coordinator',
    COMMUNITY_MANAGER: 'community_manager',
    LUXURY_PROPERTY_SPECIALIST: 'luxury_property_specialist',
    LEASING_CONSULTANT: 'leasing_consultant',
    MAINTENANCE_SUPERVISOR: 'maintenance_supervisor',
    MAINTENANCE_STAFF: 'maintenance_staff',
    FINANCIAL_OFFICER: 'financial_officer',
    FINANCIAL_ANALYST: 'financial_analyst',
    MARKETING_SPECIALIST: 'marketing_specialist',
    LEGAL_ADVISOR: 'legal_advisor',
    INSURANCE_COORDINATOR: 'insurance_coordinator',
    RELOCATION_SPECIALIST: 'relocation_specialist',
    INSPECTOR: 'inspector',
    VENDOR: 'vendor',
    BNB_HOST: 'bnb_host',
    DATA_ANALYST: 'data_analyst',
    CUSTOMER_SUPPORT_AGENT: 'customer_support_agent'
  }
};