import React from 'react'
import { BrowserRouter as Router, Routes, Route, Navigate } from 'react-router-dom'
import { AuthProvider } from '../frontend/src/contexts/AuthContext'
import { useAuth } from '../frontend/src/contexts/AuthContext'

// Layout Components
import MainLayout from '../frontend/src/components/common/Layout/MainLayout'
import AuthLayout from '../frontend/src/components/common/Layout/AuthLayout'

// Auth Pages
import Login from '../frontend/src/pages/auth/Login'
import Register from '../frontend/src/pages/auth/Register'
import ForgotPassword from '../frontend/src/pages/auth/ForgotPassword'

// Dashboard Pages for All Roles
import SuperAdminDashboard from '../frontend/src/pages/dashboard/admin/SuperAdminDashboard'
import SystemAdminDashboard from '../frontend/src/pages/dashboard/admin/SystemAdminDashboard'
import LandlordDashboard from '../frontend/src/pages/dashboard/landlord/LandlordDashboard'
import TenantDashboard from '../frontend/src/pages/dashboard/tenant/TenantDashboard'
import PropertyManagerDashboard from '../frontend/src/pages/dashboard/manager/PropertyManagerDashboard'
import RegionalManagerDashboard from '../frontend/src/pages/dashboard/manager/RegionalManagerDashboard'
import CommunityManagerDashboard from '../frontend/src/pages/dashboard/manager/CommunityManagerDashboard'
import CorporateHousingManagerDashboard from '../frontend/src/pages/dashboard/manager/CorporateHousingManagerDashboard'
import StudentHousingCoordinatorDashboard from '../frontend/src/pages/dashboard/manager/StudentHousingCoordinatorDashboard'
import LuxuryPropertySpecialistDashboard from '../frontend/src/pages/dashboard/manager/LuxuryPropertySpecialistDashboard'
import PropertyAgentDashboard from '../frontend/src/pages/dashboard/agent/PropertyAgentDashboard'
import LeasingConsultantDashboard from '../frontend/src/pages/dashboard/leasing/LeasingConsultantDashboard'
import MaintenanceSupervisorDashboard from '../frontend/src/pages/dashboard/maintenance/MaintenanceSupervisorDashboard'
import MaintenanceStaffDashboard from '../frontend/src/pages/dashboard/maintenance/MaintenanceStaffDashboard'
import FinancialOfficerDashboard from '../frontend/src/pages/dashboard/financial/FinancialOfficerDashboard'
import FinancialAnalystDashboard from '../frontend/src/pages/dashboard/financial/FinancialAnalystDashboard'
import MarketingSpecialistDashboard from '../frontend/src/pages/dashboard/marketing/MarketingSpecialistDashboard'
import LegalAdvisorDashboard from '../frontend/src/pages/dashboard/legal/LegalAdvisorDashboard'
import InsuranceCoordinatorDashboard from '../frontend/src/pages/dashboard/insurance/InsuranceCoordinatorDashboard'
import RelocationSpecialistDashboard from '../frontend/src/pages/dashboard/relocation/RelocationSpecialistDashboard'
import InspectorDashboard from '../frontend/src/pages/dashboard/inspection/InspectorDashboard'
import VendorDashboard from '../frontend/src/pages/dashboard/vendor/VendorDashboard'
import BNBHostDashboard from '../frontend/src/pages/dashboard/bnb/BNBHostDashboard'
import DataAnalystDashboard from '../frontend/src/pages/dashboard/data/DataAnalystDashboard'
import CustomerSupportAgentDashboard from '../frontend/src/pages/dashboard/support/CustomerSupportAgentDashboard'

// Property Pages
import PropertiesList from '../frontend/src/pages/properties/PropertiesList'
import PropertyDetails from '../frontend/src/pages/properties/PropertyDetails'
import AddProperty from '../frontend/src/pages/properties/AddProperty'
import EditProperty from '../frontend/src/pages/properties/EditProperty'

// Lease Pages
import LeasesList from '../frontend/src/pages/leases/LeasesList'
import LeaseDetails from '../frontend/src/pages/leases/LeaseDetails'
import CreateLease from '../frontend/src/pages/leases/CreateLease'
import LeaseAgreement from '../frontend/src/pages/leases/LeaseAgreement'

// Payment Pages
import PaymentsList from '../frontend/src/pages/payments/PaymentsList'
import PaymentHistory from '../frontend/src/pages/payments/PaymentHistory'
import MakePayment from '../frontend/src/pages/payments/MakePayment'
import PaymentDetails from '../frontend/src/pages/payments/PaymentDetails'

// Maintenance Pages
import MaintenanceList from '../frontend/src/pages/maintenance/MaintenanceList'
import MaintenanceRequest from '../frontend/src/pages/maintenance/MaintenanceRequest'
import MaintenanceDetails from '../frontend/src/pages/maintenance/MaintenanceDetails'
import ScheduleMaintenance from '../frontend/src/pages/maintenance/ScheduleMaintenance'

// User Pages
import Profile from '../frontend/src/pages/users/Profile'
import UserList from '../frontend/src/pages/users/UserList'
import EditProfile from '../frontend/src/pages/users/EditProfile'

// Report Pages
import FinancialReports from '../frontend/src/pages/reports/FinancialReports'
import OccupancyReports from '../frontend/src/pages/reports/OccupancyReports'
import MaintenanceReports from '../frontend/src/pages/reports/MaintenanceReports'

// Settings Pages
import AccountSettings from '../frontend/src/pages/settings/AccountSettings'
import NotificationSettings from '../frontend/src/pages/settings/NotificationSettings'
import BillingSettings from '../frontend/src/pages/settings/BillingSettings'

// Protected Route Component
import ProtectedRoute from '../frontend/src/components/common/ProtectedRoute'

// Loading Component
import LoadingSpinner from '../frontend/src/components/common/Loading/LoadingSpinner'

// Main App Component (without Auth)
function AppRoutes() {
  const { user, loading } = useAuth()

  if (loading) {
    return (
      <div className="d-flex justify-content-center align-items-center min-vh-100">
        <LoadingSpinner />
        <p className="mt-3">Loading StaySpot...</p>
      </div>
    )
  }

  const getDashboardComponent = () => {
    if (!user) return Login
    
    switch (user.role) {
      case 'super_admin':
        return SuperAdminDashboard
      case 'system_admin':
        return SystemAdminDashboard
      case 'landlord':
        return LandlordDashboard
      case 'tenant':
        return TenantDashboard
      case 'property_manager':
        return PropertyManagerDashboard
      case 'regional_manager':
        return RegionalManagerDashboard
      case 'community_manager':
        return CommunityManagerDashboard
      case 'corporate_housing_manager':
        return CorporateHousingManagerDashboard
      case 'student_housing_coordinator':
        return StudentHousingCoordinatorDashboard
      case 'luxury_property_specialist':
        return LuxuryPropertySpecialistDashboard
      case 'property_agent':
        return PropertyAgentDashboard
      case 'leasing_consultant':
        return LeasingConsultantDashboard
      case 'maintenance_supervisor':
        return MaintenanceSupervisorDashboard
      case 'maintenance_staff':
        return MaintenanceStaffDashboard
      case 'financial_officer':
        return FinancialOfficerDashboard
      case 'financial_analyst':
        return FinancialAnalystDashboard
      case 'marketing_specialist':
        return MarketingSpecialistDashboard
      case 'legal_advisor':
        return LegalAdvisorDashboard
      case 'insurance_coordinator':
        return InsuranceCoordinatorDashboard
      case 'relocation_specialist':
        return RelocationSpecialistDashboard
      case 'inspector':
        return InspectorDashboard
      case 'vendor':
        return VendorDashboard
      case 'bnb_host':
        return BNBHostDashboard
      case 'data_analyst':
        return DataAnalystDashboard
      case 'customer_support_agent':
        return CustomerSupportAgentDashboard
      default:
        return LandlordDashboard
    }
  }

  const DashboardComponent = getDashboardComponent()

  return (
    <Routes>
      {/* Public Routes */}
      <Route path="/auth" element={<AuthLayout />}>
        <Route path="login" element={<Login />} />
        <Route path="register" element={<Register />} />
        <Route path="forgot-password" element={<ForgotPassword />} />
      </Route>

      {/* Protected Routes */}
      <Route path="/" element={
        <ProtectedRoute>
          <MainLayout />
        </ProtectedRoute>
      }>
        {/* Dashboard Routes */}
        <Route index element={<Navigate to="/dashboard" replace />} />
        <Route path="dashboard" element={<DashboardComponent />} />
        
        {/* Property Routes */}
        <Route path="properties">
          <Route index element={<PropertiesList />} />
          <Route path="add" element={<AddProperty />} />
          <Route path=":id" element={<PropertyDetails />} />
          <Route path=":id/edit" element={<EditProperty />} />
        </Route>

        {/* Lease Routes */}
        <Route path="leases">
          <Route index element={<LeasesList />} />
          <Route path="create" element={<CreateLease />} />
          <Route path=":id" element={<LeaseDetails />} />
          <Route path=":id/agreement" element={<LeaseAgreement />} />
        </Route>

        {/* Payment Routes */}
        <Route path="payments">
          <Route index element={<PaymentsList />} />
          <Route path="history" element={<PaymentHistory />} />
          <Route path="make-payment" element={<MakePayment />} />
          <Route path=":id" element={<PaymentDetails />} />
        </Route>

        {/* Maintenance Routes */}
        <Route path="maintenance">
          <Route index element={<MaintenanceList />} />
          <Route path="request" element={<MaintenanceRequest />} />
          <Route path="schedule" element={<ScheduleMaintenance />} />
          <Route path=":id" element={<MaintenanceDetails />} />
        </Route>

        {/* User Routes */}
        <Route path="users">
          <Route index element={<UserList />} />
          <Route path="profile" element={<Profile />} />
          <Route path="profile/edit" element={<EditProfile />} />
        </Route>

        {/* Report Routes */}
        <Route path="reports">
          <Route path="financial" element={<FinancialReports />} />
          <Route path="occupancy" element={<OccupancyReports />} />
          <Route path="maintenance" element={<MaintenanceReports />} />
        </Route>

        {/* Settings Routes */}
        <Route path="settings">
          <Route path="account" element={<AccountSettings />} />
          <Route path="notifications" element={<NotificationSettings />} />
          <Route path="billing" element={<BillingSettings />} />
        </Route>
      </Route>

      {/* Catch all route */}
      <Route path="*" element={<Navigate to="/" replace />} />
    </Routes>
  )
}

// Root App Component with Providers
function App() {
  return (
    <AuthProvider>
      <Router>
        <AppRoutes />
      </Router>
    </AuthProvider>
  )
}

export default App